/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.cca;

import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.cca.MapVariablesWorldComponent;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.index.WatheProperties;
import dev.doctor4t.wathe.index.WatheSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2767;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class WorldBlackoutComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    public static final ComponentKey<WorldBlackoutComponent> KEY = ComponentRegistry.getOrCreate((class_2960)Wathe.id("blackout"), WorldBlackoutComponent.class);
    private final class_1937 world;
    private final List<BlackoutDetails> blackouts = new ArrayList<BlackoutDetails>();
    private int ticks = 0;

    public WorldBlackoutComponent(class_1937 world) {
        this.world = world;
    }

    public void reset() {
        for (BlackoutDetails detail : this.blackouts) {
            detail.end(this.world);
        }
        this.blackouts.clear();
    }

    public void serverTick() {
        for (int i = 0; i < this.blackouts.size(); ++i) {
            BlackoutDetails detail = this.blackouts.get(i);
            detail.tick(this.world);
            if (detail.time > 0) continue;
            detail.end(this.world);
            this.blackouts.remove(i);
            --i;
        }
        if (this.ticks > 0) {
            --this.ticks;
        }
    }

    public boolean isBlackoutActive() {
        return this.ticks > 0;
    }

    public boolean triggerBlackout() {
        MapVariablesWorldComponent areas = (MapVariablesWorldComponent)MapVariablesWorldComponent.KEY.get((Object)this.world);
        class_238 area = areas.playArea;
        if (this.ticks > 0) {
            return false;
        }
        for (int x = (int)area.field_1323; x <= (int)area.field_1320; ++x) {
            for (int y = (int)area.field_1322; y <= (int)area.field_1325; ++y) {
                for (int z = (int)area.field_1321; z <= (int)area.field_1324; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = this.world.method_8320(pos);
                    if (!state.method_28498((class_2769)class_2741.field_12548) || !state.method_28498((class_2769)WatheProperties.ACTIVE)) continue;
                    int duration = GameConstants.BLACKOUT_MIN_DURATION + this.world.field_9229.method_43048(GameConstants.BLACKOUT_MAX_DURATION - GameConstants.BLACKOUT_MIN_DURATION);
                    if (duration > this.ticks) {
                        this.ticks = duration;
                    }
                    BlackoutDetails detail = new BlackoutDetails(pos, duration, (Boolean)state.method_11654((class_2769)class_2741.field_12548));
                    detail.init(this.world);
                    this.blackouts.add(detail);
                }
            }
        }
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_3222 player : serverWorld.method_18456()) {
                player.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)WatheSounds.AMBIENT_BLACKOUT), class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 100.0f, 1.0f, player.method_59922().method_43055()));
            }
        }
        return true;
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 list = new class_2499();
        for (BlackoutDetails detail : this.blackouts) {
            list.add((Object)detail.writeToNbt());
        }
        tag.method_10566("blackouts", (class_2520)list);
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        this.blackouts.clear();
        for (class_2520 element : tag.method_10554("blackouts", 10)) {
            BlackoutDetails detail = new BlackoutDetails((class_2487)element);
            detail.init(this.world);
            this.blackouts.add(detail);
        }
    }

    public static class BlackoutDetails {
        private final class_2338 pos;
        private final boolean original;
        private int time;

        public BlackoutDetails(class_2338 pos, int time, boolean original) {
            this.pos = pos;
            this.time = time;
            this.original = original;
        }

        public BlackoutDetails(@NotNull class_2487 tag) {
            this.pos = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
            this.time = tag.method_10550("time");
            this.original = tag.method_10577("original");
        }

        public void init(@NotNull class_1937 world) {
            class_2680 state = world.method_8320(this.pos);
            if (!state.method_28498((class_2769)class_2741.field_12548) || !state.method_28498((class_2769)WatheProperties.ACTIVE)) {
                return;
            }
            world.method_8501(this.pos, (class_2680)((class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WatheProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
            world.method_8396(null, this.pos, WatheSounds.BLOCK_LIGHT_TOGGLE, class_3419.field_15245, 0.5f, 1.0f);
        }

        public void end(@NotNull class_1937 world) {
            class_2680 state = world.method_8320(this.pos);
            if (!state.method_28498((class_2769)class_2741.field_12548) || !state.method_28498((class_2769)WatheProperties.ACTIVE)) {
                return;
            }
            world.method_8501(this.pos, (class_2680)((class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(this.original))).method_11657((class_2769)WatheProperties.ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.method_8396(null, this.pos, WatheSounds.BLOCK_LIGHT_TOGGLE, class_3419.field_15245, 0.5f, 0.5f);
        }

        public void tick(class_1937 world) {
            if (this.time > 0) {
                --this.time;
            }
            if (this.time > 4) {
                return;
            }
            class_2680 state = world.method_8320(this.pos);
            if (!state.method_28498((class_2769)class_2741.field_12548) || !state.method_28498((class_2769)WatheProperties.ACTIVE)) {
                return;
            }
            switch (this.time) {
                case 0: {
                    this.end(world);
                    break;
                }
                case 1: 
                case 3: {
                    world.method_8501(this.pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)));
                    world.method_8396(null, this.pos, WatheSounds.BLOCK_BUTTON_TOGGLE_NO_POWER, class_3419.field_15245, 0.1f, 1.0f);
                    break;
                }
                case 2: 
                case 5: {
                    world.method_8501(this.pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)));
                    world.method_8396(null, this.pos, WatheSounds.BLOCK_BUTTON_TOGGLE_NO_POWER, class_3419.field_15245, 0.1f, 1.0f);
                }
            }
        }

        public class_2487 writeToNbt() {
            class_2487 tag = new class_2487();
            tag.method_10569("x", this.pos.method_10263());
            tag.method_10569("y", this.pos.method_10264());
            tag.method_10569("z", this.pos.method_10260());
            tag.method_10569("time", this.time);
            tag.method_10556("original", this.original);
            return tag;
        }
    }
}

